-- --------------------------------------------------------------------
--  20190125
-- --------------------------------------------------------------------
--  Added a trigger to table Stratum to calculate online quotas
--  Delete obsolete procedure Vx_sp_RespondentIncDecQuotaFrequencyAndOnline
-- --------------------------------------------------------------------

IF EXISTS(SELECT * FROM sysobjects WHERE type = 'TR' AND name = 'VX_TR_Stratum')
BEGIN
  DROP TRIGGER VX_TR_Stratum
END
GO


CREATE TRIGGER [dbo].[VX_TR_Stratum]
   ON  [dbo].[Stratum]
   AFTER INSERT, DELETE, UPDATE
AS 
BEGIN
  -- SET NOCOUNT ON added to prevent extra result sets from
  -- interfering with SELECT statements.
  SET NOCOUNT ON;

  UPDATE Quota
  SET QtOnLine = QtOnLine + ISNULL(inserted.IncrementValue, 0) - ISNULL(deleted.IncrementValue, 0)
  FROM Quota
  
  INNER JOIN
  (
      inserted FULL OUTER JOIN
      deleted ON inserted.StrStratum = deleted.StrStratum
  )
  ON QtQuotaID = COALESCE(inserted.StrQuotaID, deleted.StrQuotaID) --Use QuotaID since it is the PK (not StrStratum)
  WHERE (ISNULL(inserted.IncrementValue, 0) - ISNULL(deleted.IncrementValue, 0)) <> 0 --No update if Delta = 0
END
GO


-- Drop obsolete stored procedure that incremented frequency and online counters at once
IF EXISTS(SELECT * FROM sysobjects WHERE type = 'P' AND name = 'Vx_sp_RespondentIncDecQuotaFrequencyAndOnline')
BEGIN
  DROP PROCEDURE Vx_sp_RespondentIncDecQuotaFrequencyAndOnline
END
GO